"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CenteredWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A wrapper that centers its children both horizontally and vertically.
 */
const CenteredWrapper = ({
  children,
  ...rest
}) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
  css: (0, _react.css)`
      // 250px is roughly the Kibana chrome with a page title and tabs
      min-height: calc(100vh - 250px);
    `,
  justifyContent: "center",
  alignItems: "center",
  direction: "column"
}, rest), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, children));
exports.CenteredWrapper = CenteredWrapper;