"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _searchApiKeysServer = require("@kbn/search-api-keys-server");
var _indices = require("./indices");
var _status = require("./status");
var _documents = require("./documents");
var _onboarding = require("./onboarding");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRoutes(router, logger) {
  (0, _indices.registerIndicesRoutes)(router, logger);
  (0, _onboarding.registerOnboardingRoutes)(router, logger);
  (0, _status.registerStatusRoutes)(router, logger);
  (0, _searchApiKeysServer.registerSearchApiKeysRoutes)(router, logger);
  (0, _documents.registerDocumentRoutes)(router, logger);
}