"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBrowserFieldsByFeatureId = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../common/constants");
var _route_validation = require("./utils/route_validation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBrowserFieldsByFeatureId = router => {
  router.get({
    path: `${_constants.BASE_RAC_ALERTS_API_PATH}/browser_fields`,
    validate: {
      query: (0, _route_validation.buildRouteValidation)(t.exact(t.type({
        ruleTypeIds: t.union([t.string, t.array(t.string)])
      })))
    },
    security: {
      authz: {
        requiredPrivileges: ['rac']
      }
    },
    options: {
      access: 'internal'
    }
  }, async (context, request, response) => {
    try {
      var _ref;
      const racContext = await context.rac;
      const alertsClient = await racContext.getAlertsClient();
      const {
        ruleTypeIds = []
      } = request.query;
      const onlyO11yRuleTypeIds = (Array.isArray(ruleTypeIds) ? ruleTypeIds : [ruleTypeIds]).filter(ruleTypeId => !(0, _ruleDataUtils.isSiemRuleType)(ruleTypeId));
      const o11yIndices = (_ref = onlyO11yRuleTypeIds ? await alertsClient.getAuthorizedAlertsIndices(onlyO11yRuleTypeIds) : []) !== null && _ref !== void 0 ? _ref : [];
      if (o11yIndices.length === 0) {
        return response.notFound({
          body: {
            message: `No alerts-observability indices found for rule type ids [${onlyO11yRuleTypeIds}]`,
            attributes: {
              success: false
            }
          }
        });
      }

      // Limiting the search to fetch browser fields from the last 90 days
      const indexFilter = {
        range: {
          '@timestamp': {
            gte: 'now-90d'
          }
        }
      };
      const fields = await alertsClient.getBrowserFields({
        indices: o11yIndices,
        ruleTypeIds: onlyO11yRuleTypeIds,
        metaFields: ['_id', '_index'],
        allowNoIndex: true,
        includeEmptyFields: false,
        indexFilter
      });
      return response.ok({
        body: fields
      });
    } catch (error) {
      const formatedError = (0, _securitysolutionEsUtils.transformError)(error);
      const contentType = {
        'content-type': 'application/json'
      };
      const defaultedHeaders = {
        ...contentType
      };
      return response.customError({
        headers: defaultedHeaders,
        statusCode: formatedError.statusCode,
        body: {
          message: formatedError.message,
          attributes: {
            success: false
          }
        }
      });
    }
  });
};
exports.getBrowserFieldsByFeatureId = getBrowserFieldsByFeatureId;