"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PacksComboBoxField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PacksComboBoxField = ({
  queryType,
  fieldProps = {},
  idAria,
  ...rest
}) => {
  var _fieldState$error;
  const {
    field: {
      value,
      onChange
    },
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'packId',
    rules: {
      required: {
        message: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.osqueryPackMissingErrorMessage', {
          defaultMessage: 'Pack is a required field'
        }),
        value: queryType === 'pack'
      }
    },
    defaultValue: []
  });
  const error = (_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message;
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const handlePackChange = (0, _react.useCallback)(newSelectedOptions => {
    var _newSelectedOptions$;
    if (!newSelectedOptions.length) {
      setSelectedOptions(newSelectedOptions);
      onChange([]);
      return;
    }
    setSelectedOptions(newSelectedOptions);
    onChange([(_newSelectedOptions$ = newSelectedOptions[0].value) === null || _newSelectedOptions$ === void 0 ? void 0 : _newSelectedOptions$.id]);
  }, [onChange]);
  const packOptions = (0, _react.useMemo)(() => {
    var _fieldProps$packsData, _fieldProps$packsData2;
    return (_fieldProps$packsData = fieldProps === null || fieldProps === void 0 ? void 0 : (_fieldProps$packsData2 = fieldProps.packsData) === null || _fieldProps$packsData2 === void 0 ? void 0 : _fieldProps$packsData2.map(packSO => {
      var _packSO$name;
      return {
        label: (_packSO$name = packSO.name) !== null && _packSO$name !== void 0 ? _packSO$name : '',
        value: {
          id: packSO.saved_object_id,
          name: packSO.name,
          description: packSO.description
        }
      };
    })) !== null && _fieldProps$packsData !== void 0 ? _fieldProps$packsData : [];
  }, [fieldProps === null || fieldProps === void 0 ? void 0 : fieldProps.packsData]);
  const renderOption = (0, _react.useCallback)(({
    value: option
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    alignItems: "flexStart",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("strong", null, option === null || option === void 0 ? void 0 : option.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, option === null || option === void 0 ? void 0 : option.description)))), []);
  (0, _react.useEffect)(() => {
    if (value !== null && value !== void 0 && value.length) {
      const packOption = (0, _lodash.find)(packOptions, ['value.id', value[0]]);
      if (packOption) {
        setSelectedOptions([packOption]);
      }
    }
  }, [value, packOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.packQueryTypeLabel', {
      defaultMessage: `Pack`
    }),
    error: error,
    isInvalid: !!error,
    fullWidth: true
    // eslint-disable-next-line react-perf/jsx-no-new-array-as-prop
    ,
    describedByIds: idAria ? [idAria] : undefined
  }, rest), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    isInvalid: !!error,
    placeholder: _i18n.i18n.translate('xpack.osquery.packs.dropdown.searchFieldPlaceholder', {
      defaultMessage: `Search for a pack to run`
    }),
    selectedOptions: selectedOptions,
    onChange: handlePackChange,
    "data-test-subj": "select-live-pack",
    fullWidth: true
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    singleSelection: {
      asPlainText: true
    },
    renderOption: renderOption,
    options: packOptions,
    rowHeight: 60
  }, fieldProps)));
};
exports.PacksComboBoxField = PacksComboBoxField;