"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTools = void 0;
var _retrieval = require("./retrieval");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerTools = ({
  tools: registry
}) => {
  const tools = [(0, _retrieval.getDocumentByIdTool)(), (0, _retrieval.executeEsqlTool)(), (0, _retrieval.naturalLanguageSearchTool)(), (0, _retrieval.generateEsqlTool)(), (0, _retrieval.relevanceSearchTool)(), (0, _retrieval.getIndexMappingsTool)(), (0, _retrieval.listIndicesTool)(), (0, _retrieval.indexExplorerTool)()];
  tools.forEach(tool => {
    registry.register(tool);
  });
};
exports.registerTools = registerTools;