"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalProviderToPublic = exports.createPublicFactory = exports.createInternalRegistry = void 0;
var _combine_tool_providers = require("./combine_tool_providers");
var _tool_conversion = require("./tool_conversion");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInternalRegistry = ({
  providers,
  getRunner
}) => {
  const mainProvider = (0, _combine_tool_providers.combineToolProviders)(...providers);
  const publicRegistry = internalProviderToPublic({
    provider: mainProvider,
    getRunner
  });
  return Object.assign(mainProvider, {
    asPublicRegistry: () => publicRegistry,
    asScopedPublicRegistry: createPublicFactory(publicRegistry)
  });
};
exports.createInternalRegistry = createInternalRegistry;
const internalProviderToPublic = ({
  provider,
  getRunner
}) => {
  return {
    has(options) {
      return provider.has(options);
    },
    async get(options) {
      const tool = await provider.get(options);
      return (0, _tool_conversion.toExecutableTool)({
        tool,
        runner: getRunner(),
        request: options.request
      });
    },
    async list(options) {
      const tools = await provider.list(options);
      return tools.map(tool => (0, _tool_conversion.toExecutableTool)({
        tool,
        runner: getRunner(),
        request: options.request
      }));
    }
  };
};
exports.internalProviderToPublic = internalProviderToPublic;
const createPublicFactory = provider => {
  return ({
    request
  }) => {
    return {
      has: toolId => {
        return provider.has({
          toolId,
          request
        });
      },
      get: async toolId => {
        return provider.get({
          toolId,
          request
        });
      },
      list: async options => {
        return provider.list({
          request,
          ...options
        });
      }
    };
  };
};
exports.createPublicFactory = createPublicFactory;