"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _onechatCommon = require("@kbn/onechat-common");
var _builtin_registry = require("./builtin_registry");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ToolsService {
  constructor() {
    (0, _defineProperty2.default)(this, "builtinRegistry", void 0);
    (0, _defineProperty2.default)(this, "providers", new Map());
    this.builtinRegistry = (0, _builtin_registry.createBuiltinToolRegistry)();
    this.providers.set(_onechatCommon.builtinToolProviderId, this.builtinRegistry);
  }
  setup() {
    return {
      register: reg => this.register(reg),
      registerProvider: (providerId, provider) => {
        if (this.providers.has(providerId)) {
          throw new Error(`Provider with id ${providerId} already registered`);
        }
        this.providers.set(providerId, {
          ...provider,
          id: providerId
        });
      }
    };
  }
  start({
    getRunner
  }) {
    const registry = (0, _utils.createInternalRegistry)({
      providers: [...this.providers.values()],
      getRunner
    });
    return {
      registry
    };
  }
  register(toolRegistration) {
    this.builtinRegistry.register(toolRegistration);
  }
}
exports.ToolsService = ToolsService;