"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelLogsPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _pricing_features = require("../../../common/pricing_features");
var _template = require("./template");
var _header = require("../header");
var _otel_logs = require("../quickstart_flows/otel_logs");
var _use_pricing_feature = require("../quickstart_flows/shared/use_pricing_feature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OtelLogsPage = () => {
  const {
    services: {
      context: {
        isServerless
      }
    }
  } = (0, _public.useKibana)();
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  return /*#__PURE__*/_react.default.createElement(_template.PageTemplate, {
    customHeader: /*#__PURE__*/_react.default.createElement(_header.CustomHeader, {
      logo: "opentelemetry",
      headlineCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.otel.text', {
        defaultMessage: 'OpenTelemetry'
      }),
      captionCopy: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.otel.description', {
        defaultMessage: 'Collect logs and host metrics using the Elastic distribution of the OTel collector.'
      }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.experimentalOnboardingFlow.customHeader.otel.description', {
        defaultMessage: 'Collect logs using the Elastic distribution of the OTel collector.'
      }),
      isTechnicalPreview: isServerless
    })
  }, /*#__PURE__*/_react.default.createElement(_otel_logs.OtelLogsPanel, null));
};
exports.OtelLogsPage = OtelLogsPage;