"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseCategoryFlyout = KnowledgeBaseCategoryFlyout;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _use_delete_knowledge_base_entry = require("../../hooks/use_delete_knowledge_base_entry");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CATEGORY_MAP = {
  lens: {
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseCategoryFlyout.categoryMap.lensCategoryDescriptionLabel', {
      defaultMessage: 'Lens is a Kibana feature which allows the Assistant to visualize data in response to user queries. These Knowledge base items are loaded into the Knowledge base by default.'
    })))
  }
};
function KnowledgeBaseCategoryFlyout({
  category,
  onClose
}) {
  var _CATEGORY_MAP, _category$entries;
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const dateFormat = uiSettings.get('dateFormat');
  const {
    mutate: deleteEntry
  } = (0, _use_delete_knowledge_base_entry.useDeleteKnowledgeBaseEntry)();
  const columns = [{
    field: '@timestamp',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseCategoryFlyout.actions.dateCreated', {
      defaultMessage: 'Date created'
    }),
    sortable: true,
    render: timestamp => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, (0, _moment.default)(timestamp).format(dateFormat))
  }, {
    field: 'id',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseCategoryFlyout.actions.name', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    width: '340px'
  }, {
    name: 'Actions',
    actions: [{
      name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseCategoryFlyout.actions.delete', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseCategoryFlyout.actions.deleteDescription', {
        defaultMessage: 'Delete this entry'
      }),
      type: 'icon',
      icon: 'trash',
      onClick: ({
        id
      }) => {
        deleteEntry({
          id
        });
      }
    }]
  }];
  const hasDescription = (_CATEGORY_MAP = CATEGORY_MAP[category.categoryKey]) === null || _CATEGORY_MAP === void 0 ? void 0 : _CATEGORY_MAP.description;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "knowledgeBaseCategoryFlyout",
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, (0, _lodash.capitalize)(category.categoryKey)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, hasDescription ? hasDescription : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: (_category$entries = category.entries) !== null && _category$entries !== void 0 ? _category$entries : []
  })));
}