"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAnalyticsButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateAnalyticsButton = ({
  isDisabled,
  navigateToSourceSelection,
  size = 's'
}) => {
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isDisabled,
    fill: true,
    onClick: navigateToSourceSelection,
    iconType: "plusInCircle",
    size: size,
    "data-test-subj": "mlAnalyticsButtonCreate"
  }, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.createDataFrameAnalyticsButton', {
    defaultMessage: 'Create job'
  }));
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _check_capabilities.createPermissionFailureMessage)('canCreateDataFrameAnalytics')
    }, button);
  }
  return button;
};
exports.CreateAnalyticsButton = CreateAnalyticsButton;