"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisplayValue = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_CHARS = 12;
const DisplayValue = ({
  value
}) => {
  const length = String(value).length;
  if (length <= MAX_CHARS) {
    return /*#__PURE__*/_react.default.createElement("b", null, value);
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: value,
      anchorClassName: "valueWrapper"
    }, /*#__PURE__*/_react.default.createElement("b", null, value));
  }
};
exports.DisplayValue = DisplayValue;