"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSaveModalComponent = getSaveModalComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SaveModal = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../save_modal_container'))));
function LoadingSpinnerWithOverlay() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
}
const LensSavedModalLazy = props => {
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(LoadingSpinnerWithOverlay, null)
  }, /*#__PURE__*/_react.default.createElement(SaveModal, props));
};
function getSaveModalComponent(coreStart, startDependencies) {
  return props => {
    const [lensServices, setLensServices] = (0, _react.useState)();
    (0, _react.useEffect)(() => {
      async function loadLensService() {
        const {
          getLensServices,
          getLensAttributeService
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
        const lensServicesT = await getLensServices(coreStart, startDependencies, getLensAttributeService(coreStart, startDependencies));
        setLensServices(lensServicesT);
      }
      loadLensService();
    }, []);
    if (!lensServices) {
      return /*#__PURE__*/_react.default.createElement(LoadingSpinnerWithOverlay, null);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(LensSavedModalLazy, (0, _extends2.default)({}, props, {
      lensServices: lensServices
    })));
  };
}