"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsAndGroupByToolbarItems = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _snapshot_metric_i18n = require("../../../../../../common/snapshot_metric_i18n");
var _metric_control = require("../waffle/metric_control");
var _waffle_group_by_controls = require("../waffle/waffle_group_by_controls");
var _waffle_sort_controls = require("../waffle/waffle_sort_controls");
var _toolbar_wrapper = require("./toolbar_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsAndGroupByToolbarItems = props => {
  const metricOptions = (0, _react.useMemo)(() => props.metricTypes.map(metric => (0, _snapshot_metric_i18n.toMetricOpt)(metric, props.nodeType)).filter(v => v), [props.metricTypes, props.nodeType]);
  const groupByOptions = (0, _react.useMemo)(() => props.groupByFields.map(_toolbar_wrapper.toGroupByOpt), [props.groupByFields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_metric_control.WaffleMetricControls, {
    options: metricOptions,
    metric: props.metric,
    onChange: props.changeMetric,
    onChangeCustomMetrics: props.changeCustomMetrics,
    customMetrics: props.customMetrics
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_waffle_group_by_controls.WaffleGroupByControls, {
    options: groupByOptions,
    groupBy: props.groupBy,
    nodeType: props.nodeType,
    onChange: props.changeGroupBy,
    onChangeCustomOptions: props.changeCustomOptions,
    customOptions: props.customOptions
  })), props.view === 'map' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_waffle_sort_controls.WaffleSortControls, {
    sort: props.sort,
    onChange: props.changeSort
  })));
};
exports.MetricsAndGroupByToolbarItems = MetricsAndGroupByToolbarItems;