"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpsertViewModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nameLabel = _i18n.i18n.translate('xpack.infra.waffle.savedViews.viewNamePlaceholder', {
  defaultMessage: 'Name'
});
const UpsertViewModal = ({
  onClose,
  onSave,
  isSaving,
  initialName = '',
  initialIncludeTime = false,
  title
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [viewName, setViewName] = (0, _react.useState)(initialName);
  const [shouldIncludeTime, setIncludeTime] = (0, _react.useState)(initialIncludeTime);
  const trimmedName = viewName.trim();
  const handleNameChange = e => {
    setViewName(e.target.value);
  };
  const handleTimeCheckChange = e => {
    setIncludeTime(e.target.checked);
  };
  const saveView = () => {
    onSave(trimmedName, shouldIncludeTime);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "savedViews-upsertModal",
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: nameLabel,
    "data-test-subj": "savedViewName",
    value: viewName,
    onChange: handleNameChange,
    "aria-label": nameLabel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: 'saved-view-save-time-checkbox',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Store time with view",
      id: "xpack.infra.waffle.savedViews.includeTimeFilterLabel"
    }),
    checked: shouldIncludeTime,
    onChange: handleTimeCheckChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    grow: false,
    style: {
      maxWidth: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "This changes the time filter to the currently selected time each time the view is loaded",
    id: "xpack.infra.waffle.savedViews.includeTimeHelpText"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraSavedViewCreateModalCancelButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Cancel",
    id: "xpack.infra.waffle.savedViews.cancelButton"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: trimmedName.length === 0,
    fill: true,
    isLoading: isSaving,
    onClick: saveView,
    "data-test-subj": "createSavedViewButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Save",
    id: "xpack.infra.waffle.savedViews.saveButton"
  }))));
};
exports.UpsertViewModal = UpsertViewModal;