"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostMetricsDocsLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/visualizations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocLinks = {
  metrics: {
    href: _constants.HOST_METRICS_DOC_HREF,
    label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tooltip.whatAreTheseMetricsLink', {
      defaultMessage: 'What are these metrics?'
    })
  },
  dottedLines: {
    href: _constants.HOST_METRICS_DOTTED_LINES_DOC_HREF,
    label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tooltip.whyAmISeeingDottedLines', {
      defaultMessage: 'Why am I seeing dotted lines?'
    })
  }
};
const HostMetricsDocsLink = ({
  type
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "hostsViewMetricsDocumentationLink",
    href: DocLinks[type].href,
    target: "_blank"
  }, DocLinks[type].label));
};
exports.HostMetricsDocsLink = HostMetricsDocsLink;