"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _create_index_modal = require("./create_index_modal");
var _app_context = require("../../../../app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateIndexButton = ({
  loadIndices,
  share
}) => {
  var _share$url$locators$g;
  const [createIndexModalOpen, setCreateIndexModalOpen] = (0, _react.useState)(false);
  const createIndexUrl = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get('SEARCH_CREATE_INDEX')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  const {
    core: {
      chrome
    }
  } = (0, _app_context.useAppContext)();
  const activeSolutionId = (0, _useObservable.default)(chrome.getActiveSolutionNavId$());
  const actionProp = createIndexUrl && activeSolutionId === 'es' ? {
    href: createIndexUrl
  } : {
    onClick: () => setCreateIndexModalOpen(true)
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    fill: true,
    iconType: "plusInCircleFilled",
    key: "createIndexButton",
    "data-test-subj": "createIndexButton",
    "data-telemetry-id": "idxMgmt-indexList-createIndexButton"
  }, actionProp), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexTable.createIndexButton",
    defaultMessage: "Create index"
  })), createIndexModalOpen && /*#__PURE__*/_react.default.createElement(_create_index_modal.CreateIndexModal, {
    closeModal: () => setCreateIndexModalOpen(false),
    loadIndices: loadIndices
  }));
};
exports.CreateIndexButton = CreateIndexButton;