"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FielddataFrequencyFilterAbsolute = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FielddataFrequencyFilterAbsolute = ({
  min,
  max
}) => {
  const minIsInvalid = !min.isChangingValue && min.errors.length > 0;
  const minErrorMessage = !min.isChangingValue && min.errors.length ? min.errors[0].message : null;
  const maxIsInvalid = !max.isChangingValue && max.errors.length > 0;
  const maxErrorMessage = !max.isChangingValue && max.errors.length ? max.errors[0].message : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: minIsInvalid || maxIsInvalid,
    error: minErrorMessage || maxErrorMessage,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.fielddata.frequencyFilterAbsoluteFieldLabel",
      defaultMessage: "Absolute frequency range"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayoutDelimited, {
    isInvalid: minIsInvalid || maxIsInvalid,
    startControl: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: min.value,
      onChange: min.onChange,
      isLoading: min.isValidating,
      isInvalid: minIsInvalid,
      fullWidth: true,
      "data-test-subj": "input",
      controlOnly: true,
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.frequencyFilterAbsoluteMinAriaLabel', {
        defaultMessage: 'Minimum absolute frequency'
      })
    }),
    endControl: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: max.value,
      onChange: max.onChange,
      isLoading: max.isValidating,
      isInvalid: maxIsInvalid,
      fullWidth: true,
      "data-test-subj": "input",
      controlOnly: true,
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.frequencyFilterAbsoluteMaxAriaLabel', {
        defaultMessage: 'Maximum absolute frequency'
      })
    })
  }));
};
exports.FielddataFrequencyFilterAbsolute = FielddataFrequencyFilterAbsolute;