"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidedOnboardingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _feature = require("./feature");
var _routes = require("./routes");
var _saved_objects = require("./saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class GuidedOnboardingPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "guidesConfig", void 0);
    this.logger = initializerContext.logger.get();
    this.guidesConfig = {};
  }
  setup(core, plugins) {
    var _plugins$features;
    this.logger.debug('guidedOnboarding: Setup');
    const router = core.http.createRouter();

    // Register server side APIs
    (0, _routes.defineRoutes)(router, this.guidesConfig);

    // register saved objects
    core.savedObjects.registerType(_saved_objects.guideStateSavedObjects);
    core.savedObjects.registerType(_saved_objects.pluginStateSavedObjects);
    (_plugins$features = plugins.features) === null || _plugins$features === void 0 ? void 0 : _plugins$features.registerKibanaFeature(_feature.GUIDED_ONBOARDING_FEATURE);
    return {
      registerGuideConfig: (guideId, guideConfig) => {
        if (this.guidesConfig[guideId]) {
          throw new Error(`Unable to register a config with the guideId ${guideId} because it already exists`);
        }
        this.guidesConfig[guideId] = guideConfig;
      }
    };
  }
  start() {
    this.logger.debug('guidedOnboarding: Started');
    return {};
  }
  stop() {}
}
exports.GuidedOnboardingPlugin = GuidedOnboardingPlugin;