"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventOutput = EventOutput;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EventOutput({
  value
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.grokDebugger.structuredDataLabel",
      defaultMessage: "Structured Data"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "m",
    language: "json",
    isCopyable: true,
    "data-test-subj": "eventOutputCodeBlock"
  }, JSON.stringify(value, null, 2)));
}