"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_NAMESPACES_FILTER = void 0;
exports.agentsKueryNamespaceFilter = agentsKueryNamespaceFilter;
exports.isAgentInNamespace = isAgentInNamespace;
var _common = require("@kbn/spaces-plugin/common");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_NAMESPACES_FILTER = exports.DEFAULT_NAMESPACES_FILTER = `(namespaces:"${_common.DEFAULT_SPACE_ID}" or not namespaces:*)`;
async function isAgentInNamespace(agent, namespace) {
  var _agent$namespaces2;
  const useSpaceAwareness = await (0, _helpers.isSpaceAwarenessEnabled)();
  if (!useSpaceAwareness) {
    return true;
  }

  // In a custom space, only return true if the agent is explicitly in that space.
  if (namespace && namespace !== _common.DEFAULT_SPACE_ID) {
    var _agent$namespaces$inc, _agent$namespaces;
    return (_agent$namespaces$inc = (_agent$namespaces = agent.namespaces) === null || _agent$namespaces === void 0 ? void 0 : _agent$namespaces.includes(namespace)) !== null && _agent$namespaces$inc !== void 0 ? _agent$namespaces$inc : false;
  }

  // In the default space OR in if the current namespace is not defined,
  // return true if the agent is explicitly in the default space OR if it has no defined namespaces.
  return !agent.namespaces || agent.namespaces.length === 0 || ((_agent$namespaces2 = agent.namespaces) === null || _agent$namespaces2 === void 0 ? void 0 : _agent$namespaces2.includes(_common.DEFAULT_SPACE_ID));
}
async function agentsKueryNamespaceFilter(namespace) {
  const useSpaceAwareness = await (0, _helpers.isSpaceAwarenessEnabled)();
  if (!useSpaceAwareness || !namespace) {
    return;
  }
  return namespace === _common.DEFAULT_SPACE_ID ? DEFAULT_NAMESPACES_FILTER : `namespaces:(${namespace})`;
}