"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIntegrationFlyoutConfigureHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../../../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddIntegrationFlyoutConfigureHeader = ({
  pkgName,
  pkgVersion,
  pkgLabel,
  integration
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegrationFlyout.configureIntegrationDesc",
    defaultMessage: "Edit the necessary fields to configure your selected integration:"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
    packageName: pkgName,
    version: pkgVersion || '',
    integrationName: integration,
    size: "l",
    tryApi: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, pkgLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegrationFlyout.needMoreInfoText",
    defaultMessage: " - Need more info? {readMoreLink}",
    values: {
      readMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: `https://www.elastic.co/docs/reference/integrations/${pkgName}${integration ? '/' + integration : ''}`,
        external: true,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.addIntegrationFlyout.integrationInfoLink",
        defaultMessage: "Read more about {pkgLabel}",
        values: {
          pkgLabel
        }
      }))
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
exports.AddIntegrationFlyoutConfigureHeader = AddIntegrationFlyoutConfigureHeader;