"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasIcon = hasIcon;
exports.iconSet = void 0;
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function hasIcon(icon) {
  return icon != null && icon !== 'empty';
}
const iconSet = exports.iconSet = [{
  value: _constants.AvailableReferenceLineIcons.EMPTY,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.noIconLabel', {
    defaultMessage: 'None'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.ASTERISK,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.asteriskIconLabel', {
    defaultMessage: 'Asterisk'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.ALERT,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.alertIconLabel', {
    defaultMessage: 'Alert'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.BELL,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.bellIconLabel', {
    defaultMessage: 'Bell'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.BOLT,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.boltIconLabel', {
    defaultMessage: 'Bolt'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.BUG,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.bugIconLabel', {
    defaultMessage: 'Bug'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.CIRCLE,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.circleIconLabel', {
    defaultMessage: 'Circle'
  }),
  icon: _chartIcons.IconCircle
}, {
  value: _constants.AvailableReferenceLineIcons.EDITOR_COMMENT,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.commentIconLabel', {
    defaultMessage: 'Comment'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.FLAG,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.flagIconLabel', {
    defaultMessage: 'Flag'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.HEART,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.heartLabel', {
    defaultMessage: 'Heart'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.MAP_MARKER,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.mapMarkerLabel', {
    defaultMessage: 'Map Marker'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.PIN_FILLED,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.mapPinLabel', {
    defaultMessage: 'Map Pin'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.STAR_EMPTY,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.starLabel', {
    defaultMessage: 'Star'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.STAR_FILLED,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.starFilledLabel', {
    defaultMessage: 'Star filled'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.TAG,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.tagIconLabel', {
    defaultMessage: 'Tag'
  })
}, {
  value: _constants.AvailableReferenceLineIcons.TRIANGLE,
  label: _i18n.i18n.translate('expressionXY.xyChart.iconSelect.triangleIconLabel', {
    defaultMessage: 'Triangle'
  }),
  icon: _chartIcons.IconTriangle,
  shouldRotate: true
}];