"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _table_list = require("./components/table_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getTableList = (parentProps, services) => {
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, null, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: services.core,
    savedObjectsTagging: services.savedObjectsTagging,
    FormattedRelative: _i18nReact.FormattedRelative
  }, /*#__PURE__*/_react.default.createElement(_table_list.EventAnnotationGroupTableList, {
    toasts: services.core.notifications.toasts,
    savedObjectsTagging: services.savedObjectsTagging,
    uiSettings: services.core.uiSettings,
    eventAnnotationService: services.eventAnnotationService,
    visualizeCapabilities: services.core.application.capabilities.visualize_v2,
    parentProps: parentProps,
    dataViews: services.dataViews,
    createDataView: services.createDataView,
    queryInputServices: services.queryInputServices,
    navigateToLens: () => services.core.application.navigateToApp('lens'),
    LensEmbeddableComponent: services.LensEmbeddableComponent,
    sessionService: services.sessionService
  })));
};
exports.getTableList = getTableList;