"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _i18n = require("@kbn/i18n");
var _factories = require("../../factories");
var _complete_items = require("../../complete_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  getColumnsByType,
  innerText,
  getSuggestedUserDefinedColumnName,
  columnExists
}) {
  if (/(?:rename|,)\s+\S+\s+a$/i.test(innerText)) {
    return [asCompletionItem];
  }

  // If the left side of the rename is a column that exists, we suggest the 'AS' completion item.
  // If it doesn't exist, we suggest the '=' completion item.
  const match = innerText.match(/(?:rename|,)\s+(\S+)\s+a?$/i);
  if (match) {
    const leftSideOfRename = match[1];
    return columnExists(leftSideOfRename) ? [asCompletionItem] : [assignCompletionItem];
  }
  if (/(?:rename|,)\s+\S+\s+a?$/i.test(innerText)) {
    return [asCompletionItem, assignCompletionItem];
  }
  if (/rename(?:\s+\S+\s+(as|=)\s+\S+\s*,)*\s+\S+\s+(as|=)\s+[^\s,]+\s+$/i.test(innerText)) {
    return [_complete_items.pipeCompleteItem, {
      ..._complete_items.commaCompleteItem,
      text: ', '
    }];
  }
  if (/as\s+$/i.test(innerText)) {
    return [];
  }
  const suggestions = await getColumnsByType('any', [], {
    advanceCursor: true,
    openSuggestions: true
  });
  if (!/=\s+$/i.test(innerText)) {
    suggestions.push((0, _factories.getNewUserDefinedColumnSuggestion)(getSuggestedUserDefinedColumnName()));
  }
  return suggestions;
}
const asCompletionItem = {
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.asDoc', {
    defaultMessage: 'As'
  }),
  kind: 'Reference',
  label: 'AS',
  sortText: '1',
  text: 'AS '
};
const assignCompletionItem = {
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.assignDoc', {
    defaultMessage: '='
  }),
  kind: 'Reference',
  label: '=',
  sortText: '2',
  text: '= ',
  command: _factories.TRIGGER_SUGGESTION_COMMAND
};