"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APICallFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APICallFlyout = ({
  onClose,
  lastAPICall,
  searchApplicationName
}) => {
  const [tab, setTab] = (0, _react.useState)('request');
  const contents = JSON.stringify(lastAPICall[tab], null, 2);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m",
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.apiCallFlyout.title",
    defaultMessage: "API Call"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    style: {
      marginBottom: '-24px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: tab === 'request',
    onClick: () => setTab('request')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.apiCallFlyout.requestTab",
    defaultMessage: "Request"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: tab === 'response',
    onClick: () => setTab('response')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.apiCallFlyout.responseTab",
    defaultMessage: "Response"
  }))), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_TAB_PATH, {
      searchApplicationName,
      tabId: _routes.SearchApplicationViewTabs.CONNECT
    }),
    color: "primary",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.apiCallFlyout.searchEndpointLink",
    defaultMessage: "Search endpoint"
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      blockSize: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: "100%",
    isCopyable: true,
    isVirtualized: true
  }, contents)));
};
exports.APICallFlyout = APICallFlyout;