"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _find_prompts = require("./security_ai_prompts/find_prompts");
var _find_route = require("./alert_summary/find_route");
var _cancel_attack_discovery = require("./attack_discovery/post/cancel/cancel_attack_discovery");
var _find_attack_discoveries = require("./attack_discovery/get/find_attack_discoveries");
var _get_attack_discovery = require("./attack_discovery/get/get_attack_discovery");
var _post_attack_discovery = require("./attack_discovery/post/post_attack_discovery");
var _post_attack_discovery_bulk = require("./attack_discovery/post/post_attack_discovery_bulk");
var _create_route = require("./user_conversations/create_route");
var _delete_route = require("./user_conversations/delete_route");
var _read_route = require("./user_conversations/read_route");
var _update_route = require("./user_conversations/update_route");
var _find_route2 = require("./user_conversations/find_route");
var _bulk_actions_route = require("./user_conversations/bulk_actions_route");
var _append_conversation_messages_route = require("./user_conversations/append_conversation_messages_route");
var _get_knowledge_base_status = require("./knowledge_base/get_knowledge_base_status");
var _post_knowledge_base = require("./knowledge_base/post_knowledge_base");
var _get_evaluate = require("./evaluate/get_evaluate");
var _post_evaluate = require("./evaluate/post_evaluate");
var _get_capabilities_route = require("./capabilities/get_capabilities_route");
var _bulk_actions_route2 = require("./prompts/bulk_actions_route");
var _find_route3 = require("./prompts/find_route");
var _bulk_actions_route3 = require("./anonymization_fields/bulk_actions_route");
var _find_route4 = require("./anonymization_fields/find_route");
var _chat_complete_route = require("./chat/chat_complete_route");
var _post_actions_connector_execute = require("./post_actions_connector_execute");
var _bulk_actions_route4 = require("./knowledge_base/entries/bulk_actions_route");
var _create_route2 = require("./knowledge_base/entries/create_route");
var _find_route5 = require("./knowledge_base/entries/find_route");
var _defend_insights = require("./defend_insights");
var _delete_route2 = require("./knowledge_base/entries/delete_route");
var _update_route2 = require("./knowledge_base/entries/update_route");
var _get_attack_discovery_generations = require("./attack_discovery/get/get_attack_discovery_generations");
var _post_attack_discovery_generations_dismiss = require("./attack_discovery/post/post_attack_discovery_generations_dismiss");
var _get_route = require("./knowledge_base/entries/get_route");
var _bulk_actions_route5 = require("./alert_summary/bulk_actions_route");
var _create = require("./attack_discovery/schedules/create");
var _get = require("./attack_discovery/schedules/get");
var _update = require("./attack_discovery/schedules/update");
var _delete = require("./attack_discovery/schedules/delete");
var _find = require("./attack_discovery/schedules/find");
var _disable = require("./attack_discovery/schedules/disable");
var _enable = require("./attack_discovery/schedules/enable");
var _delete_all_route = require("./user_conversations/delete_all_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = (router, logger, config) => {
  /** PUBLIC */
  // Chat
  (0, _chat_complete_route.chatCompleteRoute)(router, config);

  /** INTERNAL */
  // Capabilities
  (0, _get_capabilities_route.getCapabilitiesRoute)(router);

  // User Conversations CRUD
  (0, _create_route.createConversationRoute)(router);
  (0, _read_route.readConversationRoute)(router);
  (0, _update_route.updateConversationRoute)(router);
  (0, _delete_route.deleteConversationRoute)(router);
  (0, _delete_all_route.deleteAllConversationsRoute)(router);
  (0, _append_conversation_messages_route.appendConversationMessageRoute)(router);

  // User Conversations bulk CRUD
  (0, _bulk_actions_route.bulkActionConversationsRoute)(router, logger);

  // User Conversations search
  (0, _find_route2.findUserConversationsRoute)(router);

  // Knowledge Base Setup
  (0, _get_knowledge_base_status.getKnowledgeBaseStatusRoute)(router);
  (0, _post_knowledge_base.postKnowledgeBaseRoute)(router);

  // Knowledge Base Entries
  (0, _get_route.getKnowledgeBaseEntryRoute)(router);
  (0, _find_route5.findKnowledgeBaseEntriesRoute)(router);
  (0, _create_route2.createKnowledgeBaseEntryRoute)(router);
  (0, _update_route2.updateKnowledgeBaseEntryRoute)(router);
  (0, _delete_route2.deleteKnowledgeBaseEntryRoute)(router);
  (0, _bulk_actions_route4.bulkActionKnowledgeBaseEntriesRoute)(router);

  // Actions Connector Execute (LLM Wrapper)
  (0, _post_actions_connector_execute.postActionsConnectorExecuteRoute)(router, config);

  // Evaluate
  (0, _get_evaluate.getEvaluateRoute)(router);
  (0, _post_evaluate.postEvaluateRoute)(router);

  // Prompts
  (0, _bulk_actions_route2.bulkPromptsRoute)(router, logger);
  (0, _find_route3.findPromptsRoute)(router, logger);

  // Security AI Prompts
  (0, _find_prompts.findSecurityAIPromptsRoute)(router, logger);

  // Anonymization Fields
  (0, _bulk_actions_route3.bulkActionAnonymizationFieldsRoute)(router, logger);
  (0, _find_route4.findAnonymizationFieldsRoute)(router, logger);

  // Attack Discovery
  (0, _find_attack_discoveries.findAttackDiscoveriesRoute)(router);
  (0, _post_attack_discovery_bulk.postAttackDiscoveryBulkRoute)(router);
  (0, _get_attack_discovery_generations.getAttackDiscoveryGenerationsRoute)(router);
  (0, _post_attack_discovery_generations_dismiss.postAttackDiscoveryGenerationsDismissRoute)(router);
  (0, _get_attack_discovery.getAttackDiscoveryRoute)(router);
  (0, _post_attack_discovery.postAttackDiscoveryRoute)(router);
  (0, _cancel_attack_discovery.cancelAttackDiscoveryRoute)(router);

  // Attack Discovery Schedules
  (0, _create.createAttackDiscoverySchedulesRoute)(router);
  (0, _get.getAttackDiscoverySchedulesRoute)(router);
  (0, _find.findAttackDiscoverySchedulesRoute)(router);
  (0, _update.updateAttackDiscoverySchedulesRoute)(router);
  (0, _delete.deleteAttackDiscoverySchedulesRoute)(router);
  (0, _disable.disableAttackDiscoverySchedulesRoute)(router);
  (0, _enable.enableAttackDiscoverySchedulesRoute)(router);

  // Alert Summary
  (0, _bulk_actions_route5.bulkAlertSummaryRoute)(router, logger);
  (0, _find_route.findAlertSummaryRoute)(router, logger);

  // Defend insights
  (0, _defend_insights.getDefendInsightRoute)(router);
  (0, _defend_insights.getDefendInsightsRoute)(router);
  (0, _defend_insights.postDefendInsightsRoute)(router);
};
exports.registerRoutes = registerRoutes;