"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.combineGenerationsWithSuccessMetadata = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const combineGenerationsWithSuccessMetadata = ({
  successfulGenerationsMetadata,
  transformedGenerations
}) => {
  const {
    generations
  } = transformedGenerations;
  const combinedGenerations = generations.map(generation => {
    const {
      connector_id: connectorId
    } = generation;
    const successMetadata = successfulGenerationsMetadata[connectorId];
    return {
      ...generation,
      ...(successMetadata != null ? {
        connector_stats: {
          average_successful_duration_nanoseconds: successMetadata.averageSuccessfulDurationNanoseconds,
          successful_generations: successMetadata.successfulGenerations
        }
      } : {})
    };
  });
  return {
    generations: combinedGenerations
  };
};
exports.combineGenerationsWithSuccessMetadata = combineGenerationsWithSuccessMetadata;