"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseAuditAction = exports.AUDIT_TYPE = exports.AUDIT_OUTCOME = exports.AUDIT_CATEGORY = void 0;
exports.knowledgeBaseAuditEvent = knowledgeBaseAuditEvent;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AUDIT_TYPE = exports.AUDIT_TYPE = /*#__PURE__*/function (AUDIT_TYPE) {
  AUDIT_TYPE["CHANGE"] = "change";
  AUDIT_TYPE["DELETION"] = "deletion";
  AUDIT_TYPE["ACCESS"] = "access";
  AUDIT_TYPE["CREATION"] = "creation";
  return AUDIT_TYPE;
}({});
let AUDIT_CATEGORY = exports.AUDIT_CATEGORY = /*#__PURE__*/function (AUDIT_CATEGORY) {
  AUDIT_CATEGORY["AUTHENTICATION"] = "authentication";
  AUDIT_CATEGORY["DATABASE"] = "database";
  AUDIT_CATEGORY["WEB"] = "web";
  return AUDIT_CATEGORY;
}({});
let AUDIT_OUTCOME = exports.AUDIT_OUTCOME = /*#__PURE__*/function (AUDIT_OUTCOME) {
  AUDIT_OUTCOME["FAILURE"] = "failure";
  AUDIT_OUTCOME["SUCCESS"] = "success";
  AUDIT_OUTCOME["UNKNOWN"] = "unknown";
  return AUDIT_OUTCOME;
}({});
let KnowledgeBaseAuditAction = exports.KnowledgeBaseAuditAction = /*#__PURE__*/function (KnowledgeBaseAuditAction) {
  KnowledgeBaseAuditAction["CREATE"] = "knowledge_base_entry_create";
  KnowledgeBaseAuditAction["UPDATE"] = "knowledge_base_entry_update";
  KnowledgeBaseAuditAction["DELETE"] = "knowledge_base_entry_delete";
  return KnowledgeBaseAuditAction;
}({});
const knowledgeBaseEventVerbs = {
  knowledge_base_entry_create: ['create', 'creating', 'created'],
  knowledge_base_entry_update: ['update', 'updating', 'updated'],
  knowledge_base_entry_delete: ['delete', 'deleting', 'deleted']
};
const knowledgeBaseEventTypes = {
  knowledge_base_entry_create: AUDIT_TYPE.CREATION,
  knowledge_base_entry_update: AUDIT_TYPE.CHANGE,
  knowledge_base_entry_delete: AUDIT_TYPE.DELETION
};
function knowledgeBaseAuditEvent({
  action,
  error,
  id,
  name,
  outcome
}) {
  let doc = 'a knowledge base entry';
  if (id && name) {
    doc = `knowledge base entry [id=${id}, name="${name}"]`;
  } else if (id) {
    doc = `knowledge base entry [id=${id}]`;
  } else if (name) {
    doc = `knowledge base entry [name="${name}"]`;
  }
  const [present, progressive, past] = knowledgeBaseEventVerbs[action];
  const message = error ? `Failed attempt to ${present} ${doc}` : outcome === 'unknown' ? `User is ${progressive} ${doc}` : `User has ${past} ${doc}`;
  const type = knowledgeBaseEventTypes[action];
  return {
    message,
    event: {
      action,
      category: [AUDIT_CATEGORY.DATABASE],
      type: type ? [type] : undefined,
      outcome: error ? AUDIT_OUTCOME.FAILURE : outcome !== null && outcome !== void 0 ? outcome : AUDIT_OUTCOME.SUCCESS
    },
    error: error && {
      code: error.name,
      message: error.message
    }
  };
}