"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformBulkActionResponse = exports.PerformBulkActionRequestBody = exports.NormalizedConversationError = exports.ConversationsBulkCrudActionResults = exports.ConversationsBulkCrudActionResponse = exports.ConversationsBulkActionSkipResult = exports.ConversationsBulkActionSkipReason = exports.ConversationDetailsInError = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
var _common_attributes2 = require("./common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Conversations Actions API endpoint
 *   version: 1
 */

/**
 * Reason for skipping a conversation during bulk action.
 */

const ConversationsBulkActionSkipReason = exports.ConversationsBulkActionSkipReason = _zod.z.literal('CONVERSATION_NOT_MODIFIED');
const ConversationsBulkActionSkipResult = exports.ConversationsBulkActionSkipResult = _zod.z.object({
  /**
   * The ID of the conversation that was skipped.
   */
  id: _zod.z.string(),
  /**
   * The name of the conversation that was skipped.
   */
  name: _zod.z.string().optional(),
  /**
   * The reason the conversation was skipped.
   */
  skip_reason: ConversationsBulkActionSkipReason
});
const ConversationDetailsInError = exports.ConversationDetailsInError = _zod.z.object({
  /**
   * The ID of the conversation that encountered an error.
   */
  id: _zod.z.string(),
  /**
   * The name of the conversation in error.
   */
  name: _zod.z.string().optional()
});
const NormalizedConversationError = exports.NormalizedConversationError = _zod.z.object({
  /**
   * Error message.
   */
  message: _zod.z.string(),
  /**
   * HTTP status code for the error.
   */
  status_code: _zod.z.number().int(),
  /**
   * A specific error code identifying the error.
   */
  err_code: _zod.z.string().optional(),
  /**
   * A list of conversations that caused errors.
   */
  conversations: _zod.z.array(ConversationDetailsInError)
});
const ConversationsBulkCrudActionResults = exports.ConversationsBulkCrudActionResults = _zod.z.object({
  /**
   * List of conversations that were successfully updated.
   */
  updated: _zod.z.array(_common_attributes2.ConversationResponse),
  /**
   * List of conversations that were successfully created.
   */
  created: _zod.z.array(_common_attributes2.ConversationResponse),
  /**
   * List of conversation IDs that were successfully deleted.
   */
  deleted: _zod.z.array(_zod.z.string()),
  /**
   * List of conversations that were skipped during the bulk action.
   */
  skipped: _zod.z.array(ConversationsBulkActionSkipResult)
});
const ConversationsBulkCrudActionResponse = exports.ConversationsBulkCrudActionResponse = _zod.z.object({
  /**
   * Indicates whether the bulk action was successful.
   */
  success: _zod.z.boolean().optional(),
  /**
   * The HTTP status code returned for the bulk action.
   */
  status_code: _zod.z.number().int().optional(),
  /**
   * A message providing additional details about the bulk action result.
   */
  message: _zod.z.string().optional(),
  /**
   * The total number of conversations involved in the bulk action.
   */
  conversations_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: ConversationsBulkCrudActionResults,
    summary: _common_attributes.BulkCrudActionSummary,
    errors: _zod.z.array(NormalizedConversationError).optional()
  })
});
const PerformBulkActionRequestBody = exports.PerformBulkActionRequestBody = _zod.z.object({
  /**
   * Details of the bulk delete action to apply.
   */
  delete: _common_attributes.BulkActionBase.optional(),
  /**
   * List of conversations to create in bulk.
   */
  create: _zod.z.array(_common_attributes2.ConversationCreateProps).optional(),
  /**
   * List of conversations to update in bulk.
   */
  update: _zod.z.array(_common_attributes2.ConversationUpdateProps).optional()
});
const PerformBulkActionResponse = exports.PerformBulkActionResponse = ConversationsBulkCrudActionResponse;