"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPortalsRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _unifiedHistogram = require("@kbn/unified-histogram");
var _customizations = require("../../../../customizations");
var _redux = require("../../state_management/redux");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _use_discover_histogram = require("./use_discover_histogram");
var _scoped_services_provider = require("../../../../components/scoped_services_provider");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ChartPortalsRenderer = ({
  runtimeStateManager,
  children
}) => {
  const allTabIds = (0, _redux.useInternalStateSelector)(state => state.tabs.allIds);
  const currentTabId = (0, _redux.useInternalStateSelector)(state => state.tabs.unsafeCurrentId);
  const chartPortalNodes = (0, _react.useRef)({});
  chartPortalNodes.current = updatePortals(chartPortalNodes.current, allTabIds);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.keys(chartPortalNodes.current).map(tabId => {
    return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
      key: tabId,
      node: chartPortalNodes.current[tabId]
    }, /*#__PURE__*/_react.default.createElement(UnifiedHistogramGuard, {
      tabId: tabId,
      runtimeStateManager: runtimeStateManager
    }));
  }), /*#__PURE__*/_react.default.createElement(_redux.CurrentTabProvider, {
    currentTabId: currentTabId,
    currentChartPortalNode: chartPortalNodes.current[currentTabId]
  }, children));
};
exports.ChartPortalsRenderer = ChartPortalsRenderer;
const updatePortals = (portals, tabsIds) => tabsIds.reduce((acc, tabId) => ({
  ...acc,
  [tabId]: portals[tabId] || (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  })
}), {});
const UnifiedHistogramGuard = ({
  tabId,
  runtimeStateManager,
  panelsToggle
}) => {
  const isSelected = (0, _redux.useInternalStateSelector)(state => state.tabs.unsafeCurrentId === tabId);
  const currentTabRuntimeState = (0, _redux.selectTabRuntimeState)(runtimeStateManager, tabId);
  const currentCustomizationService = (0, _redux.useRuntimeState)(currentTabRuntimeState.customizationService$);
  const currentStateContainer = (0, _redux.useRuntimeState)(currentTabRuntimeState.stateContainer$);
  const currentScopedProfilesManager = (0, _redux.useRuntimeState)(currentTabRuntimeState.scopedProfilesManager$);
  const currentScopedEbtManager = (0, _redux.useRuntimeState)(currentTabRuntimeState.scopedEbtManager$);
  const currentDataView = (0, _redux.useRuntimeState)(currentTabRuntimeState.currentDataView$);
  const adHocDataViews = (0, _redux.useRuntimeState)(runtimeStateManager.adHocDataViews$);
  const isInitialized = (0, _react.useRef)(false);
  if (!isSelected && !isInitialized.current || !currentCustomizationService || !currentStateContainer || !currentDataView) {
    return null;
  }
  isInitialized.current = true;
  return /*#__PURE__*/_react.default.createElement(_redux.CurrentTabProvider, {
    currentTabId: tabId
  }, /*#__PURE__*/_react.default.createElement(_customizations.DiscoverCustomizationProvider, {
    value: currentCustomizationService
  }, /*#__PURE__*/_react.default.createElement(_discover_state_provider.DiscoverMainProvider, {
    value: currentStateContainer
  }, /*#__PURE__*/_react.default.createElement(_redux.RuntimeStateProvider, {
    currentDataView: currentDataView,
    adHocDataViews: adHocDataViews
  }, /*#__PURE__*/_react.default.createElement(_scoped_services_provider.ScopedServicesProvider, {
    scopedProfilesManager: currentScopedProfilesManager,
    scopedEBTManager: currentScopedEbtManager
  }, /*#__PURE__*/_react.default.createElement(UnifiedHistogramChartWrapper, {
    stateContainer: currentStateContainer,
    panelsToggle: panelsToggle
  }))))));
};
const UnifiedHistogramChartWrapper = ({
  stateContainer,
  panelsToggle
}) => {
  const {
    setUnifiedHistogramApi,
    ...unifiedHistogramProps
  } = (0, _use_discover_histogram.useDiscoverHistogram)(stateContainer);
  const unifiedHistogram = (0, _unifiedHistogram.useUnifiedHistogram)(unifiedHistogramProps);
  (0, _react.useEffect)(() => {
    if (unifiedHistogram.isInitialized) {
      setUnifiedHistogramApi(unifiedHistogram.api);
    }
  }, [setUnifiedHistogramApi, unifiedHistogram.api, unifiedHistogram.isInitialized]);
  const currentTabId = (0, _redux.useCurrentTabSelector)(tab => tab.id);
  (0, _react.useEffect)(() => {
    if (unifiedHistogram.layoutProps) {
      const currentTabRuntimeState = (0, _redux.selectTabRuntimeState)(stateContainer.runtimeStateManager, currentTabId);
      currentTabRuntimeState.unifiedHistogramLayoutProps$.next(unifiedHistogram.layoutProps);
    }
  }, [currentTabId, stateContainer.runtimeStateManager, unifiedHistogram.layoutProps]);
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const renderCustomChartToggleActions = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.isValidElement(panelsToggle) ? /*#__PURE__*/_react.default.cloneElement(panelsToggle, {
    renderedFor: 'histogram'
  }) : panelsToggle, [panelsToggle]);

  // Initialized when the first search has been requested or
  // when in ES|QL mode since search sessions are not supported
  if (!unifiedHistogram.isInitialized || !unifiedHistogramProps.searchSessionId && !isEsqlMode) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_unifiedHistogram.UnifiedHistogramChart, (0, _extends2.default)({}, unifiedHistogram.chartProps, {
    renderCustomChartToggleActions: renderCustomChartToggleActions
  }));
};