"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingPanel = exports.AboutPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _welcome_content = require("./welcome_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AboutPanel = ({
  onFilePickerChange,
  hasPermissionToImport
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const aboutPanelContentStyle = (0, _react.useMemo)(() => (0, _react2.css)({
    '.euiFilePicker__icon': {
      width: euiTheme.size.xxl,
      height: euiTheme.size.xxl
    }
  }), [euiTheme]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "center",
    "data-test-subj": "dataVisualizerPageFileUpload"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_welcome_content.WelcomeContent, {
    hasPermissionToImport: hasPermissionToImport
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.file.aboutPanel.uploadDataLabel', {
      defaultMessage: 'Upload data'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "filePicker",
    fullWidth: true,
    initialPromptText: _i18n.i18n.translate('xpack.dataVisualizer.file.aboutPanel.selectOrDragAndDropFileDescription', {
      defaultMessage: 'Select or drag and drop a file'
    }),
    onChange: files => onFilePickerChange(files),
    css: aboutPanelContentStyle
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }))));
};
exports.AboutPanel = AboutPanel;
const LoadingPanel = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "center",
    "data-test-subj": "dataVisualizerPageFileLoading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h1", {
      role: "alert"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.aboutPanel.analyzingDataTitle",
      defaultMessage: "Analyzing data"
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })));
};
exports.LoadingPanel = LoadingPanel;