"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _top_values = require("../../../top_values");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _use_bar_color = require("./use_bar_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IpContent = ({
  config,
  onAddFilter
}) => {
  const barColor = (0, _use_bar_color.useBarColor)();
  const {
    stats
  } = config;
  if (stats === undefined) return null;
  const {
    count,
    sampleCount,
    cardinality
  } = stats;
  if (count === undefined || sampleCount === undefined || cardinality === undefined) return null;
  const fieldFormat = 'fieldFormat' in config ? config.fieldFormat : undefined;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerIPContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), stats && /*#__PURE__*/_react.default.createElement(_top_values.TopValues, {
    stats: stats,
    fieldFormat: fieldFormat,
    barColor: barColor,
    onAddFilter: onAddFilter
  }));
};
exports.IpContent = IpContent;