"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = void 0;
var t = _interopRequireWildcard(require("../action_types"));
var _utils = require("../../services/utils");
var _auto_follow_pattern = require("../../services/auto_follow_pattern");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  byId: {},
  selectedDetailId: null,
  selectedEditId: null
};
const success = action => `${action}_SUCCESS`;
const setActiveForIds = (ids, byId, active) => {
  const shallowCopyByIds = {
    ...byId
  };
  ids.forEach(id => {
    shallowCopyByIds[id].active = active;
  });
  return shallowCopyByIds;
};
const parseAutoFollowPattern = autoFollowPattern => {
  // Extract prefix and suffix from follow index pattern
  const {
    followIndexPatternPrefix,
    followIndexPatternSuffix
  } = (0, _auto_follow_pattern.getPrefixSuffixFromFollowPattern)(autoFollowPattern.followIndexPattern);
  return {
    ...autoFollowPattern,
    followIndexPatternPrefix,
    followIndexPatternSuffix
  };
};
const reducer = (state = initialState, action) => {
  switch (action.type) {
    case success(t.AUTO_FOLLOW_PATTERN_LOAD):
      {
        return {
          ...state,
          byId: (0, _utils.arrayToObject)(action.payload.patterns.map(parseAutoFollowPattern), 'name')
        };
      }
    case success(t.AUTO_FOLLOW_PATTERN_GET):
      {
        return {
          ...state,
          byId: {
            ...state.byId,
            [action.payload.name]: parseAutoFollowPattern(action.payload)
          }
        };
      }
    case t.AUTO_FOLLOW_PATTERN_SELECT_DETAIL:
      {
        return {
          ...state,
          selectedDetailId: action.payload
        };
      }
    case t.AUTO_FOLLOW_PATTERN_SELECT_EDIT:
      {
        return {
          ...state,
          selectedEditId: action.payload
        };
      }
    case success(t.AUTO_FOLLOW_PATTERN_DELETE):
      {
        const byId = {
          ...state.byId
        };
        const {
          itemsDeleted
        } = action.payload;
        itemsDeleted.forEach(id => delete byId[id]);
        return {
          ...state,
          byId
        };
      }
    case success(t.AUTO_FOLLOW_PATTERN_PAUSE):
      {
        const {
          itemsPaused
        } = action.payload;
        return {
          ...state,
          byId: setActiveForIds(itemsPaused, state.byId, false)
        };
      }
    case success(t.AUTO_FOLLOW_PATTERN_RESUME):
      {
        const {
          itemsResumed
        } = action.payload;
        return {
          ...state,
          byId: setActiveForIds(itemsResumed, state.byId, true)
        };
      }
    default:
      return state;
  }
};
exports.reducer = reducer;