"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchConnectorsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _agentless = require("@kbn/fleet-plugin/server/services/utils/agentless");
var _connector_types = require("../common/lib/connector_types");
var _connectors = require("./routes/connectors");
var _stats = require("./routes/stats");
var _mapping = require("./routes/mapping");
var _search = require("./routes/search");
var _constants = require("../common/constants");
var _api_keys = require("./routes/api_keys");
var _task = require("./task");
var _infra_service_factory = require("./services/infra_service_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchConnectorsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "connectors", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "agentlessConnectorDeploymentsSyncService", void 0);
    (0, _defineProperty2.default)(this, "agentlessConnectorsInfraServiceFactory", void 0);
    this.connectors = [];
    this.logger = initializerContext.logger;
    this.config = initializerContext.config.get();
    this.agentlessConnectorDeploymentsSyncService = new _task.AgentlessConnectorDeploymentsSyncService(this.logger.get());
    this.agentlessConnectorsInfraServiceFactory = new _infra_service_factory.AgentlessConnectorsInfraServiceFactory();
  }
  setup(coreSetup, plugins) {
    const http = coreSetup.http;
    plugins.features.registerElasticsearchFeature({
      id: _constants.PLUGIN_ID,
      management: {
        data: [_constants.PLUGIN_ID]
      },
      privileges: [{
        requiredClusterPrivileges: ['monitor'],
        ui: []
      }]
    });
    this.connectors = (0, _connector_types.getConnectorTypes)(http.staticAssets);

    // There seems to be no way to check for agentless here
    // So we register a task, but do not execute it in `start` method
    this.logger.get().debug('Registering agentless connectors infra sync task');
    this.agentlessConnectorDeploymentsSyncService.registerInfraSyncTask(coreSetup, plugins, this.agentlessConnectorsInfraServiceFactory);
    const router = http.createRouter();

    // Enterprise Search Routes
    if (this.connectors.length > 0) {
      /**
       * Register routes
       */
      (0, _connectors.registerConnectorRoutes)({
        ...plugins,
        router,
        getStartServices: coreSetup.getStartServices,
        log: this.logger.get()
      });
      (0, _stats.registerStatsRoutes)({
        ...plugins,
        router,
        log: this.logger.get()
      });
      (0, _mapping.registerMappingRoute)({
        ...plugins,
        router,
        log: this.logger.get()
      });
      (0, _search.registerSearchRoute)({
        ...plugins,
        router,
        log: this.logger.get()
      });
      (0, _api_keys.registerApiKeysRoutes)({
        ...plugins,
        router
      });
    }
    return {
      getConnectorTypes: () => this.connectors
    };
  }
  start(core, plugins) {
    if ((0, _agentless.isAgentlessEnabled)()) {
      this.logger.get().info('Agentless is supported, scheduling initial agentless connectors infrastructure watcher task');
      this.agentlessConnectorsInfraServiceFactory.initialize({
        coreStart: core,
        plugins,
        logger: this.logger.get()
      });
      this.agentlessConnectorDeploymentsSyncService.scheduleInfraSyncTask(this.config, plugins.taskManager).catch(err => {
        this.logger.get().error(`Error scheduling agentless connectors infra sync task`, err);
      });
    } else {
      this.logger.get().info('Agentless is not supported, skipping scheduling initial agentless connectors infrastructure watcher task');
    }
    return {
      getConnectors: () => this.connectors
    };
  }
  stop() {}
}
exports.SearchConnectorsPlugin = SearchConnectorsPlugin;