"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableBodyRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _body_row = require("./body_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DraggableBodyRow = ({
  additionalProps,
  ariaRowindex,
  columns,
  disableDragging = false,
  errors,
  item,
  rowIdentifier,
  rowIndex
}) => {
  const draggableId = `draggable_row_${rowIndex}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, (0, _extends2.default)({
    index: rowIndex,
    draggableId: draggableId,
    isDragDisabled: disableDragging,
    customDragHandle: !disableDragging,
    hasInteractiveChildren: true,
    usePortal: true
  }, additionalProps), provided => /*#__PURE__*/_react.default.createElement(_body_row.BodyRow, {
    columns: columns,
    item: item,
    additionalProps: additionalProps,
    leftAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, disableDragging ? /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '16px'
      }
    }) : /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, provided.dragHandleProps, {
      "aria-label": _i18n.i18n.translate('xpack.contentConnectors.draggableBodyRow.dragHandleLabel', {
        defaultMessage: 'Drag handle'
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "grab"
    })))),
    rowIdentifier: rowIdentifier,
    errors: errors,
    ariaRowindex: ariaRowindex
  }));
};
exports.DraggableBodyRow = DraggableBodyRow;