"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canCreateCustomMatch = canCreateCustomMatch;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Determines is a field can have create a custom pattern to match during color mapping.
 */
function canCreateCustomMatch(meta) {
  var _meta$params, _meta$params2;
  if (!meta) return false;
  return (meta.type === 'number' || meta.type === 'string') && ((_meta$params = meta.params) === null || _meta$params === void 0 ? void 0 : _meta$params.id) !== 'range' && ((_meta$params2 = meta.params) === null || _meta$params2 === void 0 ? void 0 : _meta$params2.id) !== 'multi_terms';
}