"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAvailableObservableTypesMap = exports.getAvailableObservableTypes = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAvailableObservableTypes = async (casesClient, owner) => {
  var _configurations$0$obs, _configurations$;
  const configurations = await casesClient.configure.get({
    owner
  });
  const observableTypes = (_configurations$0$obs = configurations === null || configurations === void 0 ? void 0 : (_configurations$ = configurations[0]) === null || _configurations$ === void 0 ? void 0 : _configurations$.observableTypes) !== null && _configurations$0$obs !== void 0 ? _configurations$0$obs : [];
  return [...observableTypes, ..._constants.OBSERVABLE_TYPES_BUILTIN];
};
exports.getAvailableObservableTypes = getAvailableObservableTypes;
const getAvailableObservableTypesMap = async (casesClient, owner) => {
  try {
    const observableTypes = await getAvailableObservableTypes(casesClient, owner);
    const availableObservableTypesSet = new Map([...observableTypes, ..._constants.OBSERVABLE_TYPES_BUILTIN].map(observableType => [observableType.key, observableType]));
    return availableObservableTypesSet;
  } catch (error) {
    return new Map();
  }
};
exports.getAvailableObservableTypesMap = getAvailableObservableTypesMap;