"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttachmentsSynchronizationSourceQuery = exports.CAI_ATTACHMENTS_SYNCHRONIZATION_TASK_ID = exports.CAI_ATTACHMENTS_SOURCE_QUERY = exports.CAI_ATTACHMENTS_SOURCE_INDEX = exports.CAI_ATTACHMENTS_INDEX_VERSION = exports.CAI_ATTACHMENTS_INDEX_NAME = exports.CAI_ATTACHMENTS_INDEX_ALIAS = exports.CAI_ATTACHMENTS_BACKFILL_TASK_ID = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_ATTACHMENTS_INDEX_NAME = exports.CAI_ATTACHMENTS_INDEX_NAME = '.internal.cases-attachments';
const CAI_ATTACHMENTS_INDEX_ALIAS = exports.CAI_ATTACHMENTS_INDEX_ALIAS = '.cases-attachments';
const CAI_ATTACHMENTS_INDEX_VERSION = exports.CAI_ATTACHMENTS_INDEX_VERSION = 1;
const CAI_ATTACHMENTS_SOURCE_QUERY = exports.CAI_ATTACHMENTS_SOURCE_QUERY = {
  bool: {
    must: [{
      term: {
        type: 'cases-comments'
      }
    }, {
      bool: {
        should: [{
          term: {
            'cases-comments.type': 'externalReference'
          }
        }, {
          term: {
            'cases-comments.type': 'alert'
          }
        }],
        minimum_should_match: 1
      }
    }]
  }
};
const CAI_ATTACHMENTS_SOURCE_INDEX = exports.CAI_ATTACHMENTS_SOURCE_INDEX = _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX;
const CAI_ATTACHMENTS_BACKFILL_TASK_ID = exports.CAI_ATTACHMENTS_BACKFILL_TASK_ID = 'cai_attachments_backfill_task';
const CAI_ATTACHMENTS_SYNCHRONIZATION_TASK_ID = exports.CAI_ATTACHMENTS_SYNCHRONIZATION_TASK_ID = 'cai_cases_attachments_synchronization_task';
const getAttachmentsSynchronizationSourceQuery = lastSyncAt => ({
  bool: {
    must: [{
      term: {
        type: 'cases-comments'
      }
    }, {
      bool: {
        should: [{
          term: {
            'cases-comments.type': 'externalReference'
          }
        }, {
          term: {
            'cases-comments.type': 'alert'
          }
        }],
        minimum_should_match: 1
      }
    }, {
      bool: {
        should: [{
          range: {
            'cases-comments.created_at': {
              gte: lastSyncAt.toISOString()
            }
          }
        }, {
          range: {
            'cases-comments.updated_at': {
              gte: lastSyncAt.toISOString()
            }
          }
        }]
      }
    }]
  }
});
exports.getAttachmentsSynchronizationSourceQuery = getAttachmentsSynchronizationSourceQuery;