"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddToExistingCaseLensAction = exports.ACTION_ID = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ACTION_ID = exports.ACTION_ID = 'embeddable_addToExistingCase';
const createAddToExistingCaseLensAction = (casesActionContextProps, services) => {
  var _services$core$applic;
  let currentAppId;
  (_services$core$applic = services.core.application) === null || _services$core$applic === void 0 ? void 0 : _services$core$applic.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  return (0, _public.createAction)({
    id: ACTION_ID,
    type: 'actionButton',
    order: 10,
    grouping: [{
      id: 'cases',
      order: 6
    }],
    getIconType: () => 'casesApp',
    getDisplayName: () => _translations.ADD_TO_EXISTING_CASE_DISPLAYNAME,
    isCompatible: async ({
      embeddable
    }) => {
      const {
        isCompatible
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./is_compatible')));
      return isCompatible(embeddable, currentAppId, services.core);
    },
    execute: async ({
      embeddable
    }) => {
      const {
        isLensApi
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/lens-plugin/public')));
      if (!isLensApi(embeddable)) throw new _public.IncompatibleActionError();
      const {
        openModal
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./open_modal')));
      openModal(embeddable, currentAppId, casesActionContextProps, services);
    }
  });
};
exports.createAddToExistingCaseLensAction = createAddToExistingCaseLensAction;