"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLicense = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _kibana = require("./lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLicense = () => {
  var _licensing$license$;
  const {
    licensing
  } = (0, _kibana.useKibana)().services;
  const license = (0, _useObservable.default)((_licensing$license$ = licensing === null || licensing === void 0 ? void 0 : licensing.license$) !== null && _licensing$license$ !== void 0 ? _licensing$license$ : new _rxjs.Observable(), null);
  const isAtLeast = (0, _react.useCallback)(level => {
    return !!license && license.isAvailable && license.isActive && license.hasAtLeast(level);
  }, [license]);
  const isAtLeastPlatinum = (0, _react.useCallback)(() => isAtLeast('platinum'), [isAtLeast]);
  const isAtLeastGold = (0, _react.useCallback)(() => isAtLeast('gold'), [isAtLeast]);
  const isAtLeastEnterprise = (0, _react.useCallback)(() => isAtLeast('enterprise'), [isAtLeast]);
  return {
    isAtLeast,
    isAtLeastPlatinum,
    isAtLeastGold,
    isAtLeastEnterprise,
    getLicense: () => license
  };
};
exports.useLicense = useLicense;