"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPackageSystemTests = createPackageSystemTests;
var _path = require("path");
var _nunjucks = _interopRequireDefault(require("nunjucks"));
var _util = require("../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createPackageSystemTests(integrationDir, integration) {
  const systemTestsDockerDir = (0, _path.join)(integrationDir, '_dev/deploy/docker/');
  const systemTestsSamplesDir = (0, _path.join)(systemTestsDockerDir, 'sample_logs');
  (0, _util.ensureDirSync)(systemTestsSamplesDir);
  const streamVersion = '0.13.0';
  const dockerComposeVersion = '2.3';
  const dockerServices = [];
  for (const stream of integration.dataStreams) {
    const packageName = integration.name.replace(/_/g, '-');
    const dataStreamName = stream.name.replace(/_/g, '-');
    const systemTestFileName = (0, _path.join)(systemTestsSamplesDir, `test-${packageName}-${dataStreamName}.log`);
    const rawSamplesContent = stream.rawSamples.join('\n');
    (0, _util.createSync)(systemTestFileName, rawSamplesContent);
    for (const inputType of stream.inputTypes) {
      const mappedValues = {
        package_name: packageName,
        data_stream_name: dataStreamName,
        stream_version: streamVersion
      };
      const renderedService = _nunjucks.default.render(`service_${inputType.replaceAll('_', '-')}.njk`, mappedValues);
      dockerServices.push(renderedService);
    }
  }
  const renderedDockerCompose = _nunjucks.default.render('docker_compose.yml.njk', {
    services: dockerServices.join('\n'),
    docker_compose_version: dockerComposeVersion
  });
  const dockerComposeFileName = (0, _path.join)(systemTestsDockerDir, 'docker-compose.yml');
  (0, _util.createSync)(dockerComposeFileName, renderedDockerCompose);
}