"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServicesWithDashboards = getServicesWithDashboards;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSearchRequest(filters) {
  return {
    apm: {
      events: [_common.ProcessorEvent.metric, _common.ProcessorEvent.transaction]
    },
    track_total_hits: false,
    terminate_after: 1,
    size: 1,
    query: {
      bool: {
        filter: filters
      }
    }
  };
}
async function getServicesWithDashboards({
  apmEventClient,
  allLinkedCustomDashboards,
  serviceName,
  start,
  end
}) {
  const allKueryPerDashboard = allLinkedCustomDashboards.map(({
    kuery
  }) => ({
    kuery
  }));
  const allSearches = allKueryPerDashboard.map(dashboard => getSearchRequest([...(0, _server.kqlQuery)(dashboard.kuery), ...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.rangeQuery)(start, end)]));
  const filteredDashboards = [];
  if (allSearches.length > 0) {
    const allResponses = (await apmEventClient.msearch('get_services_with_dashboards', ...allSearches)).responses;
    for (let index = 0; index < allLinkedCustomDashboards.length; index++) {
      const responsePerDashboard = allResponses[index];
      const dashboard = allLinkedCustomDashboards[index];
      if (responsePerDashboard.hits.hits.length > 0) {
        filteredDashboards.push(dashboard);
      }
    }
  }
  return filteredDashboards;
}