"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExitSpansAnalysis = ExitSpansAnalysis;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _diagnostic_highlighted_exit_spans_table = require("./diagnostic_highlighted_exit_spans_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExitSpansAnalysis({
  hasMatchingDestinationResources,
  totalConnections,
  apmExitSpans = [],
  destinationNode,
  sourceNode
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.exitSpansTitle', {
    defaultMessage: 'Exit Spans Analysis'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), hasMatchingDestinationResources ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.exitSpansFound', {
    defaultMessage: 'Exit spans found for {sourceNode} → {destinationNode}',
    values: {
      sourceNode,
      destinationNode
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, totalConnections, ' ', _i18n.i18n.translate('xpack.apm.diagnosticResults.connectionsBadgeLabel', {
    defaultMessage: 'connections'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.exitSpansFoundDescription', {
    defaultMessage: 'Found {count} exit span(s) from {sourceNode} during the selected time range. These represent all outbound connections that were traced from this {sourceNode}.',
    values: {
      count: apmExitSpans.length,
      sourceNode
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "crossInCircle",
    color: "danger"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.exitSpansNotFound', {
    defaultMessage: 'No exit spans found for {sourceNode} → {destinationNode}',
    values: {
      sourceNode,
      destinationNode
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.exitSpansNotFoundDescription', {
    defaultMessage: 'No exit spans were found from {sourceNode} to {destinationNode} during the selected time range. This could indicate:',
    values: {
      sourceNode,
      destinationNode
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      marginTop: euiTheme.size.s,
      paddingLeft: euiTheme.size.base
    }
  }, /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.exitSpansNotFoundReason1', {
    defaultMessage: 'An instrumentation issue preventing proper span collection'
  })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.exitSpansNotFoundReason2', {
    defaultMessage: 'The trace/connection was not found during this time range'
  }))))), apmExitSpans.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "exitSpansDetails",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.viewConnectionDetails', {
      defaultMessage: 'View exit spans found'
    }))),
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_diagnostic_highlighted_exit_spans_table.HighlightedExitSpansTable, {
    items: apmExitSpans
  }))));
}