"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthBadge = HealthBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _service_health_status = require("../../../../../common/service_health_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HealthBadge({
  healthStatus
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (0, _service_health_status.getServiceHealthStatusBadgeColor)(euiTheme, healthStatus)
  }, (0, _service_health_status.getServiceHealthStatusLabel)(healthStatus));
}