"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = EmptyPrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _no_results_dark = _interopRequireDefault(require("../../../../assets/no_results_dark.svg"));
var _no_results_light = _interopRequireDefault(require("../../../../assets/no_results_light.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmptyPrompt() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.apm.infraTabs.emptyMessagePromptTimeRangeTitle', {
      defaultMessage: 'Expand your time range'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, _i18n.i18n.translate('xpack.apm.infraTabs.emptyMessagePromptDescription', {
      defaultMessage: 'Try searching over a longer period of time.'
    }))),
    color: "subdued",
    "data-test-subj": "metricsTableEmptyIndicesContent",
    icon: /*#__PURE__*/_react.default.createElement(NoResultsIllustration, null),
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.infraTabs.emptyMessagePromptTitle', {
      defaultMessage: 'No results match your search criteria.'
    })),
    titleSize: "m"
  });
}
function NoResultsIllustration() {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const illustration = colorMode === 'DARK' ? _no_results_dark.default : _no_results_light.default;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: noResultsIllustrationAlternativeText,
    size: "fullWidth",
    src: illustration
  });
}
const noResultsIllustrationAlternativeText = _i18n.i18n.translate('xpack.apm.infraTabs.emptyMessageIllustrationAlternativeText', {
  defaultMessage: 'A magnifying glass with an exclamation mark'
});