"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsSummary = DiagnosticsSummary;
exports.getIsCrossCluster = getIsCrossCluster;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _apm_integration_package_status = require("./apm_integration_package_status");
var _index_templates_status = require("./index_templates_status");
var _indicies_status = require("./indicies_status");
var _data_streams_status = require("./data_streams_status");
var _use_diagnostics = require("../context/use_diagnostics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DiagnosticsSummary() {
  var _diagnosticsBundle$di;
  const {
    diagnosticsBundle
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const isCrossCluster = getIsCrossCluster(diagnosticsBundle);
  const hasAllPrivileges = (_diagnosticsBundle$di = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.diagnosticsPrivileges.hasAllPrivileges) !== null && _diagnosticsBundle$di !== void 0 ? _diagnosticsBundle$di : true;
  if (isCrossCluster || !hasAllPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isCrossCluster && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CrossClusterSearchCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), diagnosticsBundle && !hasAllPrivileges && /*#__PURE__*/_react.default.createElement(PrivilegesCallout, {
      diagnosticsBundle: diagnosticsBundle
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_apm_integration_package_status.ApmIntegrationPackageStatus, null), /*#__PURE__*/_react.default.createElement(_index_templates_status.IndexTemplatesStatus, null), /*#__PURE__*/_react.default.createElement(_data_streams_status.DataStreamsStatus, null), /*#__PURE__*/_react.default.createElement(_indicies_status.FieldMappingStatus, null));
}
function CrossClusterSearchCallout() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Cross cluster search not supported",
    color: "warning"
  }, "The APM index settings is targetting remote clusters. Please note that this is not currently supported by the Diagnostics Tool and functionality will therefore be limited.");
}
function PrivilegesCallout({
  diagnosticsBundle
}) {
  const missingClusterPrivileges = Object.entries(diagnosticsBundle.diagnosticsPrivileges.cluster).filter(([privilegeName, hasPrivilege]) => !hasPrivilege).map(([privilegeName]) => privilegeName);
  const missingIndexPrivileges = Object.entries(diagnosticsBundle.diagnosticsPrivileges.index).filter(([indexName, privObject]) => !privObject.read).map(([indexName, privObject]) => indexName);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Insufficient access",
    color: "warning"
  }, "Not all features are available due to missing privileges.", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [...(missingClusterPrivileges.length > 0 ? [{
      title: 'Missing cluster privileges',
      description: missingClusterPrivileges.join(', ')
    }] : []), ...(missingIndexPrivileges.length > 0 ? [{
      title: 'Missing index privileges',
      description: missingIndexPrivileges.join(', ')
    }] : [])]
  })));
}
function getIsCrossCluster(diagnosticsBundle) {
  var _diagnosticsBundle$ap;
  return Object.values((_diagnosticsBundle$ap = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.apmIndices) !== null && _diagnosticsBundle$ap !== void 0 ? _diagnosticsBundle$ap : {}).some(indicies => {
    return (0, _esQuery.isCCSRemoteIndexName)(indicies);
  });
}