"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridColumnSortingStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _themes = require("../../../themes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridColumnSortingStyles = exports.euiDataGridColumnSortingStyles = function euiDataGridColumnSortingStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var maxStaticHeight = (0, _global_styling.mathWithUnits)(euiTheme.size.m, function (x) {
    return x * 25;
  });
  var maxResponsiveHeight = "min(".concat(maxStaticHeight, ", 75vh)");
  return {
    /**
     * Sorted fields
     */
    euiDataGridColumnSorting: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-height', maxResponsiveHeight), " ", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.s), "margin:-", euiTheme.size.s, ";", (0, _global_styling.euiYScrollWithShadows)(euiThemeContext), ";;label:euiDataGridColumnSorting;"),
    euiDataGridColumnSorting__item: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), " &.euiDataGridColumnSorting__item-isDragging{", (0, _themes.euiShadowLarge)(euiThemeContext, {
      borderAllInHighContrastMode: true
    }), " background-color:", euiTheme.colors.emptyShade, ";};label:euiDataGridColumnSorting__item;"),
    euiDataGridColumnSorting__name: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-right', euiTheme.size.xs), " ", (0, _global_styling.euiMinBreakpoint)(euiThemeContext, 'm'), "{", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.l), ";};label:euiDataGridColumnSorting__name;"),
    euiDataGridColumnSorting__order: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiMinBreakpoint)(euiThemeContext, 'm'), "{", (0, _global_styling.logicalCSS)('min-width', (0, _global_styling.mathWithUnits)(euiTheme.size.xxl, function (x) {
      return x * 5;
    })), ";}.euiButtonGroup__buttons{border:none;}.euiButtonGroupButton{font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";};label:euiDataGridColumnSorting__order;"),
    euiDataGridColumnSorting__dragHandle: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-right', euiTheme.size.xs), ";;label:euiDataGridColumnSorting__dragHandle;"),
    /**
     * 'Pick fields to sort by' popover
     */
    euiDataGridColumnSorting__fieldList: /*#__PURE__*/(0, _react.css)("display:flex;flex-direction:column;padding-block:", euiTheme.size.xs, ";", (0, _global_styling.logicalCSS)('max-height', maxResponsiveHeight), " ", (0, _global_styling.euiYScroll)(euiThemeContext), ";;label:euiDataGridColumnSorting__fieldList;"),
    euiDataGridColumnSorting__field: /*#__PURE__*/(0, _react.css)("padding-block:", euiTheme.size.xs, ";padding-inline:", euiTheme.size.s, ";outline-offset:-", euiTheme.focus.width, ";;label:euiDataGridColumnSorting__field;")
  };
};