"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInternalStateSelector = exports.useInternalStateDispatch = exports.useDataViewsForPicker = exports.useCurrentTabSelector = exports.useCurrentTabContext = exports.useCurrentTabAction = exports.useCurrentChartPortalNode = exports.InternalStateProvider = exports.CurrentTabProvider = void 0;
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _runtime_state = require("./runtime_state");
var _selectors = require("./selectors");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const internalStateContext = /*#__PURE__*/(0, _react.createContext)(
// Recommended approach for versions of Redux prior to v9:
// https://github.com/reduxjs/react-redux/issues/1565#issuecomment-867143221
null);
const InternalStateProvider = ({
  store,
  children
}) => /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
  store: store,
  context: internalStateContext
}, children);
exports.InternalStateProvider = InternalStateProvider;
const useInternalStateDispatch = exports.useInternalStateDispatch = (0, _reactRedux.createDispatchHook)(internalStateContext);
const useInternalStateSelector = exports.useInternalStateSelector = (0, _reactRedux.createSelectorHook)(internalStateContext);
const currentTabContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const CurrentTabProvider = ({
  currentTabId,
  currentChartPortalNode,
  children
}) => {
  const contextValue = (0, _react.useMemo)(() => ({
    currentTabId,
    currentChartPortalNode,
    injectCurrentTab: (0, _utils.createTabActionInjector)(currentTabId)
  }), [currentChartPortalNode, currentTabId]);
  return /*#__PURE__*/_react.default.createElement(currentTabContext.Provider, {
    value: contextValue
  }, children);
};
exports.CurrentTabProvider = CurrentTabProvider;
const useCurrentTabContext = () => {
  const context = _react.default.useContext(currentTabContext);
  if (!context) {
    throw new Error('useCurrentTabContext must be used within a CurrentTabProvider');
  }
  return context;
};
exports.useCurrentTabContext = useCurrentTabContext;
const useCurrentTabSelector = selector => {
  const {
    currentTabId
  } = useCurrentTabContext();
  return useInternalStateSelector(state => selector((0, _selectors.selectTab)(state, currentTabId)));
};
exports.useCurrentTabSelector = useCurrentTabSelector;
const useCurrentTabAction = actionCreator => {
  const {
    injectCurrentTab
  } = useCurrentTabContext();
  return (0, _react.useMemo)(() => injectCurrentTab(actionCreator), [actionCreator, injectCurrentTab]);
};
exports.useCurrentTabAction = useCurrentTabAction;
const useCurrentChartPortalNode = () => useCurrentTabContext().currentChartPortalNode;
exports.useCurrentChartPortalNode = useCurrentChartPortalNode;
const useDataViewsForPicker = () => {
  const originalAdHocDataViews = (0, _runtime_state.useAdHocDataViews)();
  const savedDataViews = useInternalStateSelector(state => state.savedDataViews);
  const defaultProfileAdHocDataViewIds = useInternalStateSelector(state => state.defaultProfileAdHocDataViewIds);
  return (0, _react.useMemo)(() => {
    const managedDataViews = originalAdHocDataViews.filter(({
      id
    }) => id && defaultProfileAdHocDataViewIds.includes(id));
    const adHocDataViews = (0, _lodash.differenceBy)(originalAdHocDataViews, managedDataViews, 'id');
    return {
      savedDataViews,
      managedDataViews,
      adHocDataViews
    };
  }, [defaultProfileAdHocDataViewIds, originalAdHocDataViews, savedDataViews]);
};
exports.useDataViewsForPicker = useDataViewsForPicker;