"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAppInfo = getAppInfo;
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getAppInfo(app) {
  var _app$status, _app$keywords;
  const {
    updater$,
    mount,
    visibleIn = _constants.DEFAULT_APP_VISIBILITY,
    ...infos
  } = app;
  return {
    ...infos,
    status: (_app$status = app.status) !== null && _app$status !== void 0 ? _app$status : _coreApplicationBrowser.AppStatus.accessible,
    visibleIn: app.status === _coreApplicationBrowser.AppStatus.inaccessible ? [] : visibleIn,
    appRoute: app.appRoute,
    keywords: (_app$keywords = app.keywords) !== null && _app$keywords !== void 0 ? _app$keywords : [],
    deepLinks: app.status === _coreApplicationBrowser.AppStatus.inaccessible ? [] : getDeepLinkInfos(app.deepLinks)
  };
}
function getDeepLinkInfos(deepLinks) {
  if (!deepLinks) return [];
  return deepLinks.map(({
    visibleIn = _constants.DEFAULT_LINK_VISIBILITY,
    ...rawDeepLink
  }) => {
    var _rawDeepLink$keywords;
    return {
      ...rawDeepLink,
      keywords: (_rawDeepLink$keywords = rawDeepLink.keywords) !== null && _rawDeepLink$keywords !== void 0 ? _rawDeepLink$keywords : [],
      visibleIn,
      deepLinks: getDeepLinkInfos(rawDeepLink.deepLinks)
    };
  });
}