"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchConnectorsPageTemplateWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
require("./page_template.scss");
var _loading = require("./loading");
var _flash_messages = require("./flash_messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchConnectorsPageTemplateWrapper = ({
  children,
  className,
  customPageSections,
  hideFlashMessages,
  isLoading,
  isEmptyState,
  emptyState,
  setPageChrome,
  ...pageTemplateProps
}) => {
  var _pageTemplateProps$ma;
  const hasCustomEmptyState = !!emptyState;
  const showCustomEmptyState = hasCustomEmptyState && isEmptyState;
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, (0, _extends2.default)({}, pageTemplateProps, {
    className: (0, _classnames.default)('searchConnectorsPageTemplate', className),
    mainProps: {
      ...pageTemplateProps.mainProps,
      className: (0, _classnames.default)('searchConnectorsPageTemplate__content', (_pageTemplateProps$ma = pageTemplateProps.mainProps) === null || _pageTemplateProps$ma === void 0 ? void 0 : _pageTemplateProps$ma.className)
    },
    isEmptyState: isEmptyState && !isLoading
  }), setPageChrome, !hideFlashMessages && /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null), isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : showCustomEmptyState ? emptyState : customPageSections ? children : /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, children));
};
exports.SearchConnectorsPageTemplateWrapper = SearchConnectorsPageTemplateWrapper;